/*
 * Decompiled with CFR 0.152.
 */
package jclass.chart;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Polygon;
import jclass.chart.ChartDataView;
import jclass.chart.JCChart;
import jclass.chart.JCChartUtil;
import jclass.chart.JCStyle;
import jclass.util.JCUtilConverter;

public class JCFillStyle
extends JCStyle {
    Color color;
    int pattern = 1;
    Image image;
    static int defaultColorIndex;
    static int defaultPattern;
    public static final int NONE = 0;
    public static final int SOLID = 1;
    public static final int PER_25 = 2;
    public static final int PER_50 = 3;
    public static final int PER_75 = 4;
    public static final int HORIZ_STRIPE = 5;
    public static final int VERT_STRIPE = 6;
    public static final int STRIPE_45 = 7;
    public static final int STRIPE_135 = 8;
    public static final int DIAG_HATCHED = 9;
    public static final int CROSS_HATCHED = 10;

    public JCFillStyle(Color color, int n) {
        this.color = color;
        this.pattern = n;
    }

    public static JCFillStyle makeDefault(JCChart jCChart) {
        return new JCFillStyle(JCFillStyle.getDefaultColor(jCChart), JCFillStyle.getDefaultPattern());
    }

    public void fillRect(Graphics graphics, int n, int n2, int n3, int n4) {
        if (graphics.getColor() != this.color) {
            graphics.setColor(this.color);
        }
        graphics.fillRect(n, n2, n3, n4);
    }

    public void fillImageRect(Graphics graphics, int n, int n2, int n3, int n4, boolean bl, boolean bl2) {
        if (this.image == null) {
            return;
        }
        Graphics graphics2 = graphics.create();
        graphics2.clipRect(n, n2, n3, n4);
        int n5 = this.image.getHeight(null);
        int n6 = this.image.getWidth(null);
        if (!bl2) {
            int n7 = n + (n3 - n6) / 2;
            if (bl) {
                int n8 = n2 + n4 - n5;
                while (n8 > n2) {
                    graphics2.drawImage(this.image, n7, n8, null);
                    n8 -= n5;
                }
                graphics2.drawImage(this.image, n7, n8, null);
            } else {
                int n9 = n2 + 1;
                while (n9 < n2 + n4) {
                    graphics2.drawImage(this.image, n7, n9, null);
                    n9 += n5;
                }
            }
        } else {
            int n10 = n2 + (n4 - n5) / 2;
            if (bl) {
                int n11 = n + 1;
                while (n11 < n + n3) {
                    graphics2.drawImage(this.image, n11, n10, null);
                    n11 += n6;
                }
            } else {
                int n12 = n + n3 - n6;
                while (n12 > n) {
                    graphics2.drawImage(this.image, n12, n10, null);
                    n12 -= n6;
                }
                graphics2.drawImage(this.image, n12, n10, null);
            }
        }
        graphics2.dispose();
    }

    public void fillOutlineRect(Graphics graphics, int n, int n2, int n3, int n4) {
        this.fillOutlineRect(graphics, n, n2, n3, n4, null);
    }

    public void fillOutlineRect(Graphics graphics, int n, int n2, int n3, int n4, Color color) {
        this.fillRect(graphics, n, n2, n3, n4);
        if (color == null) {
            color = this.calcOutlineColor();
        }
        if (graphics.getColor() != color) {
            graphics.setColor(color);
        }
        graphics.drawRect(n, n2, n3, n4);
    }

    public void fillPolygon(Graphics graphics, Polygon polygon) {
        if (graphics.getColor() != this.color) {
            graphics.setColor(this.color);
        }
        graphics.fillPolygon(polygon);
    }

    public void fillOutlinePolygon(Graphics graphics, Polygon polygon, Color color) {
        if (graphics.getColor() != this.color) {
            graphics.setColor(this.color);
        }
        graphics.fillPolygon(polygon);
        if (color == null) {
            color = this.calcOutlineColor();
        }
        if (graphics.getColor() != color) {
            graphics.setColor(color);
        }
        graphics.drawPolygon(polygon);
    }

    public void fillPolygonShadow(Graphics graphics, Polygon polygon) {
        Color color = JCChartUtil.darker(this.color);
        if (graphics.getColor() != color) {
            graphics.setColor(color);
        }
        graphics.fillPolygon(polygon);
    }

    public void fillPolygonHighlight(Graphics graphics, Polygon polygon) {
        Color color = JCChartUtil.brighter(this.color);
        if (graphics.getColor() != color) {
            graphics.setColor(color);
        }
        graphics.fillPolygon(polygon);
    }

    public void fillOutlinePolygonShadow(Graphics graphics, Polygon polygon) {
        this.fillOutlinePolygonShadow(graphics, polygon, null);
    }

    public void fillOutlinePolygonShadow(Graphics graphics, Polygon polygon, Color color) {
        Color color2 = JCChartUtil.darker(this.color);
        if (graphics.getColor() != color2) {
            graphics.setColor(color2);
        }
        graphics.fillPolygon(polygon);
        if (color == null) {
            color = this.calcOutlineColor();
        }
        if (graphics.getColor() != color) {
            graphics.setColor(color);
        }
        graphics.drawPolygon(polygon);
    }

    public void fillOutlinePolygonShadow(Graphics graphics, Polygon polygon, Color color, int n) {
        Color color2 = JCChartUtil.darker(this.color);
        if (graphics.getColor() != color2) {
            graphics.setColor(color2);
        }
        graphics.fillPolygon(polygon);
        if (color == null) {
            color = this.calcOutlineColor();
        }
        if (graphics.getColor() != color) {
            graphics.setColor(color);
        }
        int n2 = 0;
        while (n2 < polygon.xpoints.length) {
            if ((n & n2 * 2) > 0) {
                if (n2 + 1 == polygon.xpoints.length) {
                    graphics.drawLine(polygon.xpoints[n2], polygon.ypoints[n2], polygon.xpoints[0], polygon.ypoints[0]);
                } else {
                    graphics.drawLine(polygon.xpoints[n2], polygon.ypoints[n2], polygon.xpoints[n2 + 1], polygon.ypoints[n2 + 1]);
                }
            }
            ++n2;
        }
    }

    public void fillOutlinePolygonHighlight(Graphics graphics, Polygon polygon) {
        this.fillOutlinePolygonHighlight(graphics, polygon, null);
    }

    public void fillOutlinePolygonHighlight(Graphics graphics, Polygon polygon, Color color) {
        Color color2 = JCChartUtil.brighter(this.color);
        if (graphics.getColor() != color2) {
            graphics.setColor(color2);
        }
        graphics.fillPolygon(polygon);
        if (color == null) {
            color = this.calcOutlineColor();
        }
        if (graphics.getColor() != color) {
            graphics.setColor(color);
        }
        graphics.drawPolygon(polygon);
    }

    public void fillOutlinePolygonHighlight(Graphics graphics, Polygon polygon, Color color, int n) {
        Color color2 = JCChartUtil.brighter(this.color);
        if (graphics.getColor() != color2) {
            graphics.setColor(color2);
        }
        graphics.fillPolygon(polygon);
        if (color == null) {
            color = this.calcOutlineColor();
        }
        if (graphics.getColor() != color) {
            graphics.setColor(color);
        }
        int n2 = 0;
        while (n2 < polygon.xpoints.length) {
            if ((n & n2 * 2) > 0) {
                if (n2 + 1 == polygon.xpoints.length) {
                    graphics.drawLine(polygon.xpoints[n2], polygon.ypoints[n2], polygon.xpoints[0], polygon.ypoints[0]);
                } else {
                    graphics.drawLine(polygon.xpoints[n2], polygon.ypoints[n2], polygon.xpoints[n2 + 1], polygon.ypoints[n2 + 1]);
                }
            }
            ++n2;
        }
    }

    Color calcOutlineColor() {
        Color color = JCChartUtil.darker(this.color);
        if (color == this.color) {
            color = JCChartUtil.brighter(this.color);
        }
        return color;
    }

    public void fillArc(Graphics graphics, int n, int n2, int n3, int n4, int n5, int n6) {
        if (graphics.getColor() != this.color) {
            graphics.setColor(this.color);
        }
        graphics.fillArc(n, n2, n3, n4, n5, n6);
    }

    public void fillArcShadow(Graphics graphics, int n, int n2, int n3, int n4, int n5, int n6) {
        Color color = JCChartUtil.darker(this.color);
        if (graphics.getColor() != color) {
            graphics.setColor(color);
        }
        graphics.fillArc(n, n2, n3, n4, n5, n6);
    }

    public Color getColor() {
        return this.color;
    }

    public synchronized void setColor(Color color) {
        this.color = color;
    }

    public int getPattern() {
        return this.pattern;
    }

    public synchronized void setPattern(int n) {
        if (n == this.pattern) {
            return;
        }
        switch (n) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                this.pattern = n;
                return;
            }
        }
        throw new IllegalArgumentException("Invalid value for Pattern in JCFillStyle.  Must be one of NONE, SOLID, PER_25, PER_50, PER_75, HORIZ_STRIPE, VERT_STRIPE, STRIPE_45, STRIPE_135, DIAG_HATCHED or CROSS_HATCHED");
    }

    public Image getImage() {
        return this.image;
    }

    public synchronized void setImage(Image image) {
        this.image = image;
    }

    public synchronized void setImage(Component component, String string) {
        this.image = JCUtilConverter.toImage(component, string);
    }

    static Color getDefaultColor(JCChart jCChart) {
        Color color = JCStyle.defaultColors[defaultColorIndex++];
        if (defaultColorIndex >= JCStyle.defaultColors.length) {
            defaultColorIndex = 0;
        }
        if (jCChart != null && jCChart.chartArea != null) {
            ChartDataView chartDataView = jCChart.getDataView(0);
            int n = defaultColorIndex;
            while (chartDataView != null && chartDataView.getChartType() == 11 && color == chartDataView.getPieChartFormat().getOtherStyle().getFillColor() || color == jCChart.chartArea.getPlotArea().getBackground()) {
                color = JCStyle.defaultColors[defaultColorIndex++];
                if (defaultColorIndex >= JCStyle.defaultColors.length) {
                    defaultColorIndex = 0;
                }
                if (defaultColorIndex == n) break;
            }
        }
        return color;
    }

    static int getDefaultPattern() {
        int n = defaultPattern++;
        if (defaultPattern > 10) {
            defaultPattern = 1;
        }
        return n;
    }

    static {
        defaultPattern = 1;
    }
}

